# 📦 Clean URLs Deployment Checklist

Step-by-step guide for deploying clean URLs to your cPanel server.

---

## 📋 Files to Upload

### Required .htaccess Files

1. ✅ **Root `.htaccess`** - Main rewrite rules and security
   - Location: `/Multi-Tanent/.htaccess`
   - **CRITICAL:** Must be uploaded first

2. ✅ **`includes/.htaccess`** - Protect includes directory
   - Location: `/Multi-Tanent/includes/.htaccess`

3. ✅ **`vendor/.htaccess`** - Protect vendor directory
   - Location: `/Multi-Tanent/vendor/.htaccess`

4. ✅ **`uploads/.htaccess`** - Block PHP in uploads
   - Location: `/Multi-Tanent/uploads/.htaccess`

5. ✅ **`database/.htaccess`** - Protect database directory
   - Location: `/Multi-Tanent/database/.htaccess`

6. ✅ **`logs/.htaccess`** - Protect logs directory
   - Location: `/Multi-Tanent/logs/.htaccess`

### Testing Files

7. ✅ **`tools/test_clean_urls_comprehensive.php`** - Automated test suite
   - Location: `/Multi-Tanent/tools/test_clean_urls_comprehensive.php`

---

## 🚀 Deployment Steps

### Step 1: Backup Existing Files

**Before making any changes:**

1. **Backup existing .htaccess:**
   ```bash
   # In cPanel File Manager or via SSH
   cp .htaccess .htaccess.backup
   ```

2. **Note your current RewriteBase:**
   - Check current `.htaccess` for `RewriteBase` setting
   - Update in new `.htaccess` if different from `/Multi-Tanent/`

### Step 2: Upload Root .htaccess

1. **Via cPanel File Manager:**
   - Navigate to root directory (`/public_html/Multi-Tanent/`)
   - Upload `.htaccess` file
   - **IMPORTANT:** Make sure it's named `.htaccess` (with leading dot)
   - Set permissions: `644`

2. **Via FTP/SFTP:**
   ```bash
   # Upload .htaccess to root
   scp .htaccess user@domain.com:/home/user/public_html/Multi-Tanent/.htaccess
   ```

3. **Verify upload:**
   - File should be visible in File Manager (show hidden files)
   - Check file size > 0 bytes

### Step 3: Upload Directory Protection Files

**For each directory (`includes`, `vendor`, `uploads`, `database`, `logs`):**

1. Navigate to directory in File Manager
2. Upload corresponding `.htaccess` file
3. Set permissions: `644`
4. Verify file exists

**Quick Checklist:**
- [ ] `includes/.htaccess`
- [ ] `vendor/.htaccess`
- [ ] `uploads/.htaccess`
- [ ] `database/.htaccess` (if directory exists)
- [ ] `logs/.htaccess` (if directory exists)

### Step 4: Upload Test Suite

1. Navigate to `tools/` directory
2. Upload `test_clean_urls_comprehensive.php`
3. Set permissions: `644`

### Step 5: Update RewriteBase (if needed)

1. **Edit root `.htaccess`:**
   ```apache
   # Find this line:
   RewriteBase /Multi-Tanent/
   
   # Change if your installation is at different path:
   RewriteBase /your-actual-path/
   ```

2. **Common paths:**
   - `/Multi-Tanent/` - If in subdirectory
   - `/` - If in document root

### Step 6: Verify mod_rewrite is Enabled

1. **Check via cPanel:**
   - Go to "Apache Modules" or "Select PHP Version"
   - Ensure `mod_rewrite` is enabled

2. **Check via .htaccess test:**
   - Add to `.htaccess` temporarily:
     ```apache
     RewriteEngine On
     RewriteRule ^test-mod-rewrite$ - [F,L]
     ```
   - Access: `https://your-domain.com/Multi-Tanent/test-mod-rewrite`
   - Should return 403 (not 404)
   - Remove test rule after verification

---

## ✅ Post-Deployment Verification

### Quick Tests

1. **Test clean URL:**
   - Visit: `https://your-domain.com/Multi-Tanent/admin/dashboard`
   - Should load without .php extension

2. **Test tenant URL:**
   - Visit: `https://your-domain.com/Multi-Tanent/kine/register`
   - Should work (replace `kine` with actual school code)

3. **Test protected file:**
   - Visit: `https://your-domain.com/Multi-Tanent/config.php`
   - Should return 403 Forbidden (not accessible)

4. **Run automated test:**
   - Visit: `https://your-domain.com/Multi-Tanent/tools/test_clean_urls_comprehensive.php`
   - Review test results

### Verify Security

1. **Test protected directories:**
   ```
   https://your-domain.com/Multi-Tanent/includes/functions.php → 403
   https://your-domain.com/Multi-Tanent/vendor/autoload.php → 403
   https://your-domain.com/Multi-Tanent/database/ → 403
   https://your-domain.com/Multi-Tanent/logs/ → 403
   ```

2. **Test upload directory:**
   - Upload a test PHP file to `uploads/test.php`
   - Try to access: `https://your-domain.com/Multi-Tanent/uploads/test.php`
   - Should return 403 Forbidden

---

## 🐛 Troubleshooting

### Issue: 500 Internal Server Error

**Cause:** Syntax error in .htaccess or mod_rewrite not enabled

**Solution:**
1. Check Apache error logs in cPanel
2. Verify mod_rewrite is enabled
3. Check .htaccess syntax
4. Restore backup: `cp .htaccess.backup .htaccess`

### Issue: 404 Not Found on Clean URLs

**Cause:** RewriteBase incorrect or mod_rewrite not working

**Solution:**
1. Check RewriteBase path matches installation
2. Verify mod_rewrite is enabled
3. Check Apache error logs
4. Test with `curl -I` to see redirects

### Issue: Protected Files Still Accessible

**Cause:** .htaccess files not uploaded or not being processed

**Solution:**
1. Verify all .htaccess files are uploaded
2. Check file permissions (644)
3. Verify AllowOverride is enabled (may need hosting support)
4. Check Apache error logs

### Issue: Infinite Redirect Loop

**Cause:** Conflicting rewrite rules or HTTPS enforcement

**Solution:**
1. Check for conflicting RewriteRules
2. Disable HTTPS enforcement temporarily
3. Check Apache error logs
4. Review redirect logic

---

## 📝 Post-Deployment Tasks

### Optional: Enable HTTPS Enforcement

1. **Edit root `.htaccess`:**
   ```apache
   # Find and uncomment:
   RewriteCond %{HTTPS} off
   RewriteRule ^(.*)$ https://%{HTTP_HOST}%{REQUEST_URI} [L,R=301]
   ```

2. **Test:**
   - Access via HTTP: `http://your-domain.com/Multi-Tanent/`
   - Should redirect to HTTPS

### Optional: Custom Error Pages

1. **Create error pages:**
   - `404.php` - Not Found
   - `403.php` - Forbidden
   - `500.php` - Server Error

2. **Uncomment in `.htaccess`:**
   ```apache
   ErrorDocument 404 /Multi-Tanent/404.php
   ErrorDocument 403 /Multi-Tanent/403.php
   ErrorDocument 500 /Multi-Tanent/500.php
   ```

---

## 🔐 Security Checklist

After deployment, verify:

- [ ] Directory browsing disabled
- [ ] Sensitive files blocked (.sql, .log, .ini, .env)
- [ ] Config files not accessible
- [ ] Includes directory protected
- [ ] Vendor directory protected
- [ ] Database directory protected
- [ ] Logs directory protected
- [ ] PHP execution blocked in uploads
- [ ] Security headers enabled (if mod_headers available)

---

## 📞 Support Resources

- **Apache Error Logs:** `cPanel → Metrics → Errors`
- **Test Suite:** `https://your-domain.com/Multi-Tanent/tools/test_clean_urls_comprehensive.php`
- **Testing Guide:** See `CLEAN_URLS_TESTING_GUIDE.md`
- **Quick Reference:** See `CLEAN_URLS_QUICK_REFERENCE.md`

---

## ✅ Deployment Complete Checklist

- [ ] Root `.htaccess` uploaded and verified
- [ ] All directory `.htaccess` files uploaded
- [ ] Test suite uploaded
- [ ] RewriteBase updated (if needed)
- [ ] mod_rewrite verified enabled
- [ ] Clean URLs tested and working
- [ ] Tenant isolation URLs tested
- [ ] Protected files verified blocked
- [ ] Security tests passed
- [ ] Apache error logs reviewed (no errors)

---

**Deployment Date:** _________________  
**Deployed By:** _________________  
**Status:** ☐ Pending | ☐ In Progress | ☐ Complete

---

**Last Updated:** 2025-01-16  
**Version:** 2.0

