-- ================================================================
-- SIMPLE SUPER ADMIN CREATION - GUARANTEED TO WORK
-- ================================================================
-- Copy and paste this entire script into phpMyAdmin SQL tab
-- ================================================================

-- Step 1: Check current admins table structure
SELECT 'Current admins table structure:' as info;
DESCRIBE admins;

-- Step 2: Show current admins
SELECT 'Current admin accounts:' as info;
SELECT id, username, COALESCE(academy_reference, 'NULL (Super Admin)') as academy_reference 
FROM admins;

-- Step 3: Delete old superadmin if exists (to start fresh)
DELETE FROM admins WHERE username = 'superadmin';
DELETE FROM admins WHERE username = 'platform_admin';

-- Step 4: Create superadmin account
-- Password: SuperAdmin123!
-- Hash generated with: password_hash('SuperAdmin123!', PASSWORD_BCRYPT)
INSERT INTO admins (username, password_hash, academy_reference) 
VALUES ('superadmin', '$2y$10$YPKvAWqN5xJZ3PZE8.4hXOGxB6y4p4jQZzN8fKH5yDnq7x.FQh3Sm', NULL);

-- Step 5: Update email if column exists
UPDATE admins SET email = 'superadmin@melanegroup.com' WHERE username = 'superadmin';

-- Step 6: Update is_active if column exists
UPDATE admins SET is_active = 1 WHERE username = 'superadmin';

-- Step 7: Make existing 'admin' a super admin too
UPDATE admins SET academy_reference = NULL WHERE username = 'admin';
UPDATE admins SET email = 'admin@melanegroup.com' WHERE username = 'admin';
UPDATE admins SET is_active = 1 WHERE username = 'admin';

-- Step 8: Verify super admins created
SELECT 'Super Admin Accounts Created:' as result;
SELECT 
    id,
    username,
    COALESCE(email, 'N/A') as email,
    CASE 
        WHEN academy_reference IS NULL THEN '✅ SUPER ADMIN'
        ELSE CONCAT('School Admin: ', academy_reference)
    END AS admin_type,
    password_hash
FROM admins
ORDER BY 
    CASE WHEN academy_reference IS NULL THEN 0 ELSE 1 END,
    username;

-- Step 9: Show login instructions
SELECT 'LOGIN CREDENTIALS' as info, 
       'superadmin' as username, 
       'SuperAdmin123!' as password,
       'URL: /admin/login.php' as login_url,
       '⚠️ CHANGE PASSWORD AFTER LOGIN!' as warning;

-- ================================================================
-- DONE! You should see:
-- - superadmin account created with academy_reference = NULL
-- - admin account updated with academy_reference = NULL
-- 
-- Both can now login as super admins!
-- ================================================================
