-- ================================================================
-- FIX ACADEMY_REFERENCES TABLE - Add Missing Columns
-- ================================================================
-- Run this in cPanel → phpMyAdmin → SQL tab
-- ================================================================

-- Show current structure
SELECT 'Current academy_references table structure:' as info;
DESCRIBE academy_references;

-- Add missing columns
ALTER TABLE academy_references 
ADD COLUMN IF NOT EXISTS admin_id INT(11) NULL AFTER reference_code;

ALTER TABLE academy_references 
ADD COLUMN IF NOT EXISTS academy_name VARCHAR(255) NOT NULL DEFAULT 'New School' AFTER admin_id;

ALTER TABLE academy_references 
ADD COLUMN IF NOT EXISTS is_active TINYINT(1) DEFAULT 1 AFTER academy_name;

ALTER TABLE academy_references 
ADD COLUMN IF NOT EXISTS created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP AFTER is_active;

-- Add index for performance
ALTER TABLE academy_references 
ADD INDEX IF NOT EXISTS idx_admin_id (admin_id);

-- Verify structure
SELECT 'Updated academy_references table structure:' as info;
DESCRIBE academy_references;

-- Show current schools
SELECT 'Current schools:' as info;
SELECT * FROM academy_references ORDER BY id;

-- ================================================================
-- DONE! academy_references table is now ready for school creation
-- ================================================================
