<?php
require_once '../includes/functions.php';
require_once '../includes/school_context.php';

// Get school from URL (for branded login pages via clean URLs)
$url_school_code = $_GET['school'] ?? '';
$school_branding = null;

if ($url_school_code) {
    $pdo = getDB();
    $stmt = $pdo->prepare("
        SELECT ar.reference_code, ar.academy_name, ts.setting_key, ts.setting_value
        FROM academy_references ar
        LEFT JOIN tenant_settings ts ON ar.reference_code = ts.academy_reference
        WHERE ar.reference_code = ? AND ar.is_active = 1
    ");
    $stmt->execute([strtoupper($url_school_code)]);
    $results = $stmt->fetchAll();
    
    if (!empty($results)) {
        $school_branding = [
            'code' => $results[0]['reference_code'],
            'name' => $results[0]['academy_name']
        ];
        foreach ($results as $row) {
            if ($row['setting_key']) {
                $school_branding[$row['setting_key']] = $row['setting_value'];
            }
        }
    }
}

// Redirect if already logged in
if (isAdminLoggedIn()) {
    // Check if school context is set
    if (getCurrentSchool()) {
        // Use clean URL for redirect
        header('Location: /Multi-Tanent/admin/dashboard');
    } else {
        header('Location: /Multi-Tanent/select_school.php');
    }
    exit;
}

$error = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Validate CSRF token
    if (!validateCSRFToken($_POST['csrf_token'] ?? '')) {
        $error = 'Invalid security token. Please try again.';
    } else {
        $username = trim($_POST['username'] ?? '');
        $password = trim($_POST['password'] ?? '');
        
        if (adminLogin($username, $password)) {
            // After successful login, set school context
            $pdo = getDB();
            $stmt = $pdo->prepare("SELECT academy_reference FROM admins WHERE username = ?");
            $stmt->execute([$username]);
            $academy_ref = $stmt->fetchColumn();
            
            if ($academy_ref && setCurrentSchool($academy_ref)) {
                // Use clean URL for redirect
                header('Location: /Multi-Tanent/admin/dashboard');
            } else {
                // Multiple schools or no school assigned - show selector
                header('Location: /Multi-Tanent/select_school.php');
            }
            exit;
        } else {
            $error = 'Invalid username or password.';
        }
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Admin Login - <?php echo APP_NAME; ?></title>
    
    <!-- Favicon -->
    <link rel="icon" type="image/svg+xml" href="../images/img-melanesys-logo.svg">
    <link rel="alternate icon" href="../images/img-melanesys-logo.svg">
    <link rel="apple-touch-icon" href="../images/img-melanesys-logo.svg">
    
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.min.css" rel="stylesheet">
</head>
<body class="bg-light">
    <div class="container">
        <div class="row justify-content-center min-vh-100 align-items-center">
            <div class="col-md-4">
                <div class="card shadow">
                    <div class="card-header bg-primary text-white text-center">
                        <h3 class="card-title mb-0">
                            <i class="bi bi-shield-lock me-2"></i>Admin Login
                        </h3>
                    </div>
                    <div class="card-body">
                        <?php if ($error): ?>
                            <div class="alert alert-danger">
                                <i class="bi bi-exclamation-triangle me-1"></i><?php echo htmlspecialchars($error); ?>
                            </div>
                        <?php endif; ?>
                        
                        <form method="POST" action="/Multi-Tanent/admin/login.php">
                            <input type="hidden" name="csrf_token" value="<?php echo generateCSRFToken(); ?>">
                            <div class="mb-3">
                                <label for="username" class="form-label">Username</label>
                                <div class="input-group">
                                    <span class="input-group-text">
                                        <i class="bi bi-person"></i>
                                    </span>
                                    <input type="text" class="form-control" id="username" name="username" 
                                           value="<?php echo htmlspecialchars($_POST['username'] ?? ''); ?>" required>
                                </div>
                            </div>
                            
                            <div class="mb-3">
                                <label for="password" class="form-label">Password</label>
                                <div class="input-group">
                                    <span class="input-group-text">
                                        <i class="bi bi-lock"></i>
                                    </span>
                                    <input type="password" class="form-control" id="password" name="password" required>
                                </div>
                            </div>
                            
                            <div class="d-grid">
                                <button type="submit" class="btn btn-primary">
                                    <i class="bi bi-box-arrow-in-right me-1"></i>Login
                                </button>
                            </div>
                        </form>
                    </div>
                    <div class="card-footer text-center">
                        <a href="../index.php" class="text-decoration-none">
                            <i class="bi bi-arrow-left me-1"></i>Back to Registration
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>

