<?php
/**
 * Upload Payment Receipt (Tenant-Aware)
 */

session_start();
require_once '../../config.php';
require_once '../../includes/functions.php';
require_once '../../includes/tenant_directory_manager.php';
require_once '../../includes/tenant_file_upload.php';

// Check authentication
if (!isAdminLoggedIn()) {
    http_response_code(401);
    echo json_encode(['success' => false, 'error' => 'Unauthorized']);
    exit;
}

$tenant_id = $_SESSION['academy_reference'];

// Database connection
$conn = getDB();

// Initialize upload handler
$dirManager = new TenantDirectoryManager($conn);
$uploader = new TenantFileUpload($conn, $dirManager);

// Handle upload
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_FILES['receipt'])) {
    $payment_id = (int)$_POST['payment_id'];
    
    // Verify payment belongs to this tenant
    $stmt = $conn->prepare("
        SELECT id FROM payments 
        WHERE id = ? AND academy_reference = ?
    ");
    $stmt->execute([$payment_id, $tenant_id]);
    
    if (!$stmt->fetch()) {
        http_response_code(403);
        echo json_encode(['success' => false, 'error' => 'Payment not found']);
        exit;
    }
    
    // Upload receipt
    $result = $uploader->uploadPaymentReceipt(
        $tenant_id,
        $payment_id,
        $_FILES['receipt']
    );
    
    // Return response
    header('Content-Type: application/json');
    echo json_encode($result);
    exit;
}

http_response_code(400);
echo json_encode(['success' => false, 'error' => 'Invalid request']);

