<?php
// Database configuration for XAMPP
define('DB_HOST', '127.0.0.1');
define('DB_PORT', 3306);
define('DB_NAME', 'multi_tenant_skoloi');
define('DB_USER', 'root');
define('DB_PASS', '');
define('DB_CHARSET', 'utf8mb4');

// SMTP configuration - Configured for melanegroup.com
define('SMTP_HOST', 'mail.melanegroup.com');
define('SMTP_PORT', 587);
define('SMTP_USERNAME', 'info@melanegroup.com');
define('SMTP_PASSWORD', 'P@$$word1Q*'); // Replace with your actual email password
define('SMTP_ENCRYPTION', 'tls');
define('SMTP_FROM_EMAIL', 'info@melanegroup.com');
define('SMTP_FROM_NAME', 'Skolo-Kine Learning Platform');

// SMS Gateway Configuration
define('SMS_ENABLED', true); // Enable/disable SMS
define('SMS_PROVIDER', 'africastalking'); // 'africastalking' or 'twilio'

// Africa's Talking Configuration (Recommended for Africa)
// Sign up at: https://africastalking.com/
define('AT_USERNAME', 'sandbox'); // Change to your username in production
define('AT_API_KEY', 'your-api-key-here'); // Get from dashboard
define('AT_SENDER_ID', 'SKOLO'); // Your registered sender ID (max 11 chars)
define('AT_ENVIRONMENT', 'sandbox'); // 'sandbox' or 'production'

// Twilio Configuration (Alternative/Backup)
define('TWILIO_ACCOUNT_SID', 'your-account-sid');
define('TWILIO_AUTH_TOKEN', 'your-auth-token');
define('TWILIO_FROM_NUMBER', '+268XXXXXXXX'); // Your Twilio number

// SMS Settings
define('SMS_COUNTRY_CODE', '+268'); // Eswatini country code
define('SMS_VERIFICATION_EXPIRY', 15); // Verification code expiry in minutes
define('SMS_MAX_ATTEMPTS', 3); // Max verification attempts

// Application settings
define('APP_NAME', 'Multi-Tenant');

// Payment settings
define('SUBJECT_PRICE', 0.30); // Price per subject in SZL
define('MAX_STUDENTS', 500);
define('ADMIN_USERNAME', 'admin');
define('ADMIN_PASSWORD', 'admin123');

// WhatsApp Group Link (replace with your actual WhatsApp group invite link)
define('WHATSAPP_GROUP_LINK', 'https://chat.whatsapp.com/G6drhwZoJtZJsJXfINOhV2?mode=ems_wa_t');

// Moodle Platform URL
define('MOODLE_URL', 'https://skoloi.melanegroup.com/kine/');

// Moodle API Configuration
define('MOODLE_API_URL', 'https://skoloi.melanegroup.com/kine/webservice/rest/server.php');
define('MOODLE_API_TOKEN', 'edb3c3837e8d5b89ae35b92d1dfc40e2'); // Update this with your new token after setup

// Error reporting for development (enable to see errors)
error_reporting(E_ALL);
ini_set('display_errors', 1);
ini_set('log_errors', 1);

// Debug mode for admin portal
define('APP_DEBUG', true);

// MTN MoMo (Collection) Sandbox configuration
define('MOMO_ENV', 'sandbox');
define('MOMO_COLLECTION_SUBSCRIPTION_KEY', 'b292b7357d0b4c53bf1c257e353d70f5'); // Ocp-Apim-Subscription-Key
define('MOMO_COLLECTION_SUBSCRIPTION_KEY_SECONDARY', '87420e0c9b0d41129f72dc50f02df1a8');
// API User and API Key should be stored securely; for sandbox we support Basic auth for token endpoint
define('MOMO_API_USER_ID', 'f87b455b-6235-4e15-bb0d-b5fd0e28441a'); // sandbox provided
define('MOMO_API_KEY', 'd49b83fe32554db884f4c2023e1b58c6');     // sandbox provided
define('MOMO_CURRENCY', 'EUR');
define('MOMO_COUNTRY_ISO', 'SZ');
define('MOMO_COLLECTION_BASE_URL', 'https://sandbox.momodeveloper.mtn.com/collection');
define('MOMO_CALLBACK_PATH', '/payments/mtn/callback'); // append to your public base URL
define('PUBLIC_BASE_URL', 'https://kine.melanegroup.com/Skolo-Kine');

// Subject pricing (flat for now)
define('SUBJECT_PRICE_SZL', 0.30);

// =====================================================
// PAYMENT REMINDER SYSTEM CONFIGURATION
// =====================================================

// Default payment settings (can be overridden per tenant)
define('DEFAULT_PAYMENT_CYCLE_DAYS', 30); // Monthly payments
define('DEFAULT_REMINDER_DAYS', 27); // Send reminder 27 days after payment
define('DEFAULT_WARNING_DAYS', 3); // Send warning 3 days after reminder
define('DEFAULT_SUSPENSION_DAYS', 35); // Suspend at 35 days
define('DEFAULT_MONTHLY_FEE', 350.00); // SZL 350 per month
define('DEFAULT_UNSUSPENSION_FEE', 50.00); // SZL 50 to reactivate

// Payment link settings
define('PAYMENT_LINK_EXPIRY_HOURS', 48); // Payment links valid for 48 hours
define('PAYMENT_TOKEN_ALGORITHM', 'AES-256-CBC'); // Encryption algorithm

// =====================================================
// WALLET & WITHDRAWAL SYSTEM CONFIGURATION
// =====================================================

// Platform fee configuration
define('PLATFORM_FEE_TYPE', 'FIXED'); // FIXED fee per student
define('PLATFORM_FEE_FIXED', 0.50); // SZL 0.50 per student
define('PLATFORM_MOMO_NUMBER', '76873207'); // Your MoMo wallet number
define('PLATFORM_ADMIN_ID', 1); // Your admin ID

// Withdrawal settings (MTN MoMo Disbursement API)
define('MIN_WITHDRAWAL_AMOUNT', 10.00); // Minimum SZL 10 (MTN requirement)
define('WITHDRAWAL_PROCESSING_FEE', 0.00); // No additional fee
define('AUTO_WITHDRAWAL_ENABLED', false); // Manual withdrawals only

// MTN MoMo Disbursement API (for withdrawals)
// NOTE: You need to register for Disbursement API separately from Collection
define('MOMO_DISBURSEMENT_SUBSCRIPTION_KEY', 'your-disbursement-subscription-key'); // Get from MTN Developer Portal
define('MOMO_DISBURSEMENT_BASE_URL', 'https://sandbox.momodeveloper.mtn.com/disbursement');
define('MOMO_DISBURSEMENT_USER_ID', 'your-disbursement-user-id'); // Create via API provisioning
define('MOMO_DISBURSEMENT_API_KEY', 'your-disbursement-api-key'); // Generate after creating user

// Academy reference configuration
define('DEFAULT_ACADEMY_REFERENCE', 'KINE'); // Default: Kine Academy
define('ACADEMY_NAME', 'Kine Academy');

// =====================================================

// =====================================================
// CARD PAYMENT CONFIGURATION (PayGate)
// =====================================================

// PayGate configuration for card payments
define('PAYGATE_ENABLED', false); // Disabled - waiting for correct API credentials
define('PAYGATE_ID', '3235ed64-5f2c-479f-a9da-eace4f7d50ad'); // OAuth Client ID (needs PayWeb 3 ID instead)
define('PAYGATE_SECRET', 'oLHzL64jssdxBy7tn3XjmwXPe5NSTQfM'); // OAuth Client Secret
define('PAYGATE_ENCRYPTION_KEY', '+sqV0j2WJQ4cfMd+ANQ4AoKoWx/uaJTQODftWNTKrw8='); // OAuth Encryption Key
define('PAYGATE_URL', 'https://secure.paygate.co.za/payweb3/process.trans');
define('PAYGATE_TEST_MODE', true); // Set to false for production

// NOTE: The credentials above are OAuth/REST API credentials (Client ID format).
// PayWeb 3 requires a 10-digit PayGate ID instead.
// Contact PayGate support to get the correct credentials:
// - Email: support@paygate.co.za
// - Phone: +27 (0)21 797 5140
// See PAYGATE_CREDENTIALS_ISSUE.md for details

// Card payment fees
define('CARD_PROCESSING_FEE_PERCENTAGE', 3.0); // 3% card processing fee
define('CARD_FEE_PAID_BY', 'PLATFORM'); // 'PLATFORM' or 'STUDENT'

// =====================================================

// Database connection
function getDB() {
    static $pdo = null;
    if ($pdo === null) {
        $dsn = "mysql:host=" . DB_HOST . ";port=" . DB_PORT . ";dbname=" . DB_NAME . ";charset=" . DB_CHARSET;
        $options = [
            PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
            PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
            PDO::ATTR_EMULATE_PREPARES => false
        ];
        try {
            $pdo = new PDO($dsn, DB_USER, DB_PASS, $options);
        } catch (PDOException $e) {
            // Show detailed error for debugging
            die('Database connection failed: ' . $e->getMessage() . 
                '<br>Host: ' . DB_HOST . 
                '<br>Database: ' . DB_NAME . 
                '<br>User: ' . DB_USER);
        }
    }
    return $pdo;
}