-- ===================================================================
-- QUICK FIX for SQL Errors
-- Run this if you encountered errors with the previous SQL scripts
-- ===================================================================

-- Fix 1: Drop parent_students table if it exists with wrong ENUM
DROP TABLE IF EXISTS parent_students;

-- Fix 2: Recreate parent_students table with correct ENUM
CREATE TABLE IF NOT EXISTS parent_students (
    id INT AUTO_INCREMENT PRIMARY KEY,
    parent_id INT NOT NULL,
    student_id INT NOT NULL,
    
    -- Relationship details (FIXED: added 'parent' to ENUM)
    relationship ENUM('parent', 'mother', 'father', 'guardian', 'grandparent', 'other') DEFAULT 'parent',
    is_primary BOOLEAN DEFAULT FALSE,
    can_make_payments BOOLEAN DEFAULT TRUE,
    can_view_grades BOOLEAN DEFAULT TRUE,
    
    -- Metadata
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
    
    -- Constraints
    UNIQUE KEY unique_parent_student (parent_id, student_id),
    FOREIGN KEY (parent_id) REFERENCES parents(id) ON DELETE CASCADE,
    FOREIGN KEY (student_id) REFERENCES students(id) ON DELETE CASCADE,
    
    -- Indexes
    INDEX idx_parent (parent_id),
    INDEX idx_student (student_id),
    INDEX idx_primary (is_primary)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Verify table was created
SELECT 'parent_students table fixed!' as status;

-- Show table structure
DESCRIBE parent_students;

