-- Add missing Moodle and payment cycle columns to students table
-- This script is safe to run multiple times (errors for existing columns are handled by PHP script)

-- Add Moodle integration and payment cycle columns one by one
ALTER TABLE `students` ADD COLUMN `last_payment_date` DATETIME NULL;
ALTER TABLE `students` ADD COLUMN `next_payment_due` DATETIME NULL;
ALTER TABLE `students` ADD COLUMN `payment_cycle_start` DATETIME NULL;
ALTER TABLE `students` ADD COLUMN `payment_reminder_sent` TINYINT(1) DEFAULT 0;
ALTER TABLE `students` ADD COLUMN `warning_email_sent` TINYINT(1) DEFAULT 0;
ALTER TABLE `students` ADD COLUMN `suspension_warning_sent` TINYINT(1) DEFAULT 0;
ALTER TABLE `students` ADD COLUMN `moodle_status` VARCHAR(20) DEFAULT 'active';
ALTER TABLE `students` ADD COLUMN `suspended_date` DATETIME NULL;

-- Add indexes for the new columns
ALTER TABLE `students` ADD INDEX `idx_students_moodle_status` (`moodle_status`);
ALTER TABLE `students` ADD INDEX `idx_students_next_payment_due` (`next_payment_due`);

-- Create payment_cycles table if it doesn't exist
CREATE TABLE IF NOT EXISTS `payment_cycles` (
    `id` INT NOT NULL AUTO_INCREMENT,
    `student_id` INT NOT NULL,
    `cycle_start` DATETIME NOT NULL,
    `cycle_end` DATETIME NOT NULL,
    `amount_due` DECIMAL(10,2) NOT NULL,
    `amount_paid` DECIMAL(10,2) DEFAULT 0.00,
    `status` ENUM('active','paid','overdue','suspended') DEFAULT 'active',
    `payment_date` DATETIME NULL,
    `created_at` TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    PRIMARY KEY (`id`),
    KEY `idx_student_cycle` (`student_id`,`cycle_start`),
    KEY `idx_status` (`status`),
    KEY `idx_cycle_end` (`cycle_end`),
    CONSTRAINT `fk_payment_cycles_student` FOREIGN KEY (`student_id`) REFERENCES `students`(`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

