-- System monitoring tables for Skolo-Kine

-- System performance monitoring
CREATE TABLE IF NOT EXISTS system_metrics (
    id INT AUTO_INCREMENT PRIMARY KEY,
    metric_name VARCHAR(100) NOT NULL,
    metric_value DECIMAL(10,4) NOT NULL,
    metric_unit VARCHAR(20) NOT NULL,
    server_info JSON NULL,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    INDEX idx_metric_name (metric_name),
    INDEX idx_created_at (created_at)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- Application performance monitoring
CREATE TABLE IF NOT EXISTS app_performance (
    id INT AUTO_INCREMENT PRIMARY KEY,
    page_name VARCHAR(100) NOT NULL,
    response_time DECIMAL(8,3) NOT NULL,
    memory_usage INT NOT NULL,
    query_count INT DEFAULT 0,
    error_count INT DEFAULT 0,
    user_agent TEXT NULL,
    ip_address VARCHAR(45) NULL,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    INDEX idx_page_name (page_name),
    INDEX idx_created_at (created_at)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- Database performance monitoring
CREATE TABLE IF NOT EXISTS database_metrics (
    id INT AUTO_INCREMENT PRIMARY KEY,
    query_type VARCHAR(50) NOT NULL,
    execution_time DECIMAL(8,3) NOT NULL,
    rows_affected INT DEFAULT 0,
    query_text TEXT NULL,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    INDEX idx_query_type (query_type),
    INDEX idx_created_at (created_at)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- User activity monitoring
CREATE TABLE IF NOT EXISTS user_activity (
    id INT AUTO_INCREMENT PRIMARY KEY,
    user_id INT NULL,
    user_type ENUM('STUDENT', 'ADMIN', 'GUEST') NOT NULL,
    action VARCHAR(100) NOT NULL,
    page_url VARCHAR(500) NULL,
    ip_address VARCHAR(45) NOT NULL,
    user_agent TEXT NULL,
    session_id VARCHAR(128) NULL,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    INDEX idx_user_id (user_id),
    INDEX idx_user_type (user_type),
    INDEX idx_action (action),
    INDEX idx_created_at (created_at)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- Error logging
CREATE TABLE IF NOT EXISTS error_logs (
    id INT AUTO_INCREMENT PRIMARY KEY,
    error_type VARCHAR(50) NOT NULL,
    error_message TEXT NOT NULL,
    error_file VARCHAR(500) NULL,
    error_line INT NULL,
    stack_trace TEXT NULL,
    user_id INT NULL,
    ip_address VARCHAR(45) NULL,
    user_agent TEXT NULL,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    INDEX idx_error_type (error_type),
    INDEX idx_created_at (created_at)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- API monitoring
CREATE TABLE IF NOT EXISTS api_monitoring (
    id INT AUTO_INCREMENT PRIMARY KEY,
    api_endpoint VARCHAR(200) NOT NULL,
    method VARCHAR(10) NOT NULL,
    response_code INT NOT NULL,
    response_time DECIMAL(8,3) NOT NULL,
    request_size INT DEFAULT 0,
    response_size INT DEFAULT 0,
    user_id INT NULL,
    ip_address VARCHAR(45) NULL,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    INDEX idx_api_endpoint (api_endpoint),
    INDEX idx_response_code (response_code),
    INDEX idx_created_at (created_at)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- Bot monitoring
CREATE TABLE IF NOT EXISTS bot_monitoring (
    id INT AUTO_INCREMENT PRIMARY KEY,
    bot_name VARCHAR(100) NOT NULL,
    status ENUM('RUNNING', 'STOPPED', 'ERROR', 'IDLE') NOT NULL,
    last_run TIMESTAMP NULL,
    next_run TIMESTAMP NULL,
    execution_time DECIMAL(8,3) NULL,
    records_processed INT DEFAULT 0,
    errors_count INT DEFAULT 0,
    memory_usage INT NULL,
    cpu_usage DECIMAL(5,2) NULL,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
    INDEX idx_bot_name (bot_name),
    INDEX idx_status (status),
    INDEX idx_last_run (last_run)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- System health checks
CREATE TABLE IF NOT EXISTS health_checks (
    id INT AUTO_INCREMENT PRIMARY KEY,
    check_name VARCHAR(100) NOT NULL,
    status ENUM('HEALTHY', 'WARNING', 'CRITICAL', 'UNKNOWN') NOT NULL,
    check_value DECIMAL(10,4) NULL,
    threshold_warning DECIMAL(10,4) NULL,
    threshold_critical DECIMAL(10,4) NULL,
    message TEXT NULL,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    INDEX idx_check_name (check_name),
    INDEX idx_status (status),
    INDEX idx_created_at (created_at)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- Alert system
CREATE TABLE IF NOT EXISTS alerts (
    id INT AUTO_INCREMENT PRIMARY KEY,
    alert_type VARCHAR(50) NOT NULL,
    severity ENUM('LOW', 'MEDIUM', 'HIGH', 'CRITICAL') NOT NULL,
    title VARCHAR(200) NOT NULL,
    message TEXT NOT NULL,
    status ENUM('ACTIVE', 'ACKNOWLEDGED', 'RESOLVED', 'SUPPRESSED') DEFAULT 'ACTIVE',
    acknowledged_by INT NULL,
    acknowledged_at TIMESTAMP NULL,
    resolved_at TIMESTAMP NULL,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    INDEX idx_alert_type (alert_type),
    INDEX idx_severity (severity),
    INDEX idx_status (status),
    INDEX idx_created_at (created_at)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- System uptime tracking
CREATE TABLE IF NOT EXISTS uptime_tracking (
    id INT AUTO_INCREMENT PRIMARY KEY,
    service_name VARCHAR(100) NOT NULL,
    status ENUM('UP', 'DOWN', 'DEGRADED') NOT NULL,
    response_time DECIMAL(8,3) NULL,
    error_message TEXT NULL,
    checked_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    INDEX idx_service_name (service_name),
    INDEX idx_status (status),
    INDEX idx_checked_at (checked_at)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;
