-- =====================================================
-- Optional: Add moodle_last_sync column
-- Run this ONLY if you want to track when students were last synced
-- The system works fine without this column!
-- =====================================================

-- Check if column exists first
ALTER TABLE students 
ADD COLUMN IF NOT EXISTS moodle_last_sync TIMESTAMP NULL COMMENT 'Last sync with Moodle';

-- Add index for faster queries
CREATE INDEX IF NOT EXISTS idx_moodle_last_sync ON students(moodle_last_sync);

-- =====================================================
-- If you run this, you'll need to update the code to use it:
-- 
-- 1. In admin/moodle/sync_students.php line 50:
--    Change: SET moodle_user_id = ?, moodle_synced = 1
--    To:     SET moodle_user_id = ?, moodle_synced = 1, moodle_last_sync = NOW()
--
-- 2. In includes/moodle_api.php line 312:
--    Change: moodle_synced = TRUE
--    To:     moodle_synced = TRUE, moodle_last_sync = CURRENT_TIMESTAMP
-- =====================================================

