<?php
/**
 * Payment Success Page
 * Shows payment confirmation and receipt
 */

require_once '../includes/functions.php';
require_once '../includes/parent_functions.php';
requireParentLogin();

$parent_id = $_SESSION['parent_id'];
$pdo = getDB();

// Get payment success data from session
if (!isset($_SESSION['payment_success'])) {
    header('Location: dashboard.php');
    exit;
}

$payment = $_SESSION['payment_success'];
$academy_reference = $_SESSION['academy_reference'] ?? '';

// Get school settings for currency
$stmt = $pdo->prepare("SELECT setting_key, setting_value FROM tenant_settings WHERE academy_reference = ?");
$stmt->execute([$academy_reference]);
$settings = [];
while ($row = $stmt->fetch()) {
    $settings[$row['setting_key']] = $row['setting_value'];
}
$currency_symbol = $settings['currency_symbol'] ?? 'E';
$schoolName = $settings['school_name'] ?? 'School';

// Clear payment success data (can only view once)
unset($_SESSION['payment_success']);
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Payment Successful - Parent Portal</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.min.css" rel="stylesheet">
    <style>
        :root {
            --primary: #667eea;
            --secondary: #764ba2;
        }
        body {
            background: linear-gradient(135deg, #f5f7fa 0%, #c3cfe2 100%);
            min-height: 100vh;
            display: flex;
            align-items: center;
            padding: 20px 0;
        }
        .success-icon {
            width: 100px;
            height: 100px;
            background: linear-gradient(135deg, #10b981 0%, #059669 100%);
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            margin: 0 auto 1rem;
            animation: scaleIn 0.5s ease-out;
        }
        @keyframes scaleIn {
            from { transform: scale(0); }
            to { transform: scale(1); }
        }
        .card {
            border: none;
            border-radius: 1rem;
            box-shadow: 0 10px 40px rgba(0,0,0,0.1);
            animation: slideUp 0.5s ease-out;
        }
        @keyframes slideUp {
            from { opacity: 0; transform: translateY(30px); }
            to { opacity: 1; transform: translateY(0); }
        }
        .confetti {
            position: fixed;
            width: 10px;
            height: 10px;
            background: #667eea;
            position: absolute;
            animation: confetti-fall 3s ease-in infinite;
        }
        @keyframes confetti-fall {
            to {
                transform: translateY(100vh) rotate(360deg);
                opacity: 0;
            }
        }
    </style>
</head>
<body>
    <!-- Confetti effect -->
    <script>
        // Create confetti
        for (let i = 0; i < 50; i++) {
            const confetti = document.createElement('div');
            confetti.className = 'confetti';
            confetti.style.left = Math.random() * 100 + '%';
            confetti.style.animationDelay = Math.random() * 3 + 's';
            confetti.style.backgroundColor = ['#667eea', '#764ba2', '#10b981', '#f59e0b'][Math.floor(Math.random() * 4)];
            document.body.appendChild(confetti);
        }
    </script>

    <div class="container">
        <div class="row justify-content-center">
            <div class="col-md-8">
                <div class="card">
                    <div class="card-body p-5 text-center">
                        <!-- Success Icon -->
                        <div class="success-icon">
                            <i class="bi bi-check-lg text-white" style="font-size: 3rem;"></i>
                        </div>
                        
                        <!-- Success Message -->
                        <h1 class="text-success mb-3">Payment Successful!</h1>
                        <p class="lead text-muted mb-4">
                            Your payment has been processed successfully.
                        </p>
                        
                        <!-- Payment Details -->
                        <div class="card bg-light mb-4">
                            <div class="card-body">
                                <h4 class="mb-4">Payment Receipt</h4>
                                
                                <div class="row mb-3">
                                    <div class="col-6 text-start text-muted">Student:</div>
                                    <div class="col-6 text-end"><strong><?= htmlspecialchars($payment['student_name']) ?></strong></div>
                                </div>
                                
                                <div class="row mb-3">
                                    <div class="col-6 text-start text-muted">Subjects:</div>
                                    <div class="col-6 text-end"><strong><?= $payment['subject_count'] ?> Subject<?= $payment['subject_count'] > 1 ? 's' : '' ?></strong></div>
                                </div>
                                
                                <div class="row mb-3">
                                    <div class="col-6 text-start text-muted">Payment Period:</div>
                                    <div class="col-6 text-end">
                                        <strong><?= $payment['payment_period'] === 'yearly' ? '12 Months (Yearly)' : '1 Month (Monthly)' ?></strong>
                                    </div>
                                </div>
                                
                                <div class="row mb-3">
                                    <div class="col-6 text-start text-muted">Reference:</div>
                                    <div class="col-6 text-end"><code><?= htmlspecialchars($payment['reference']) ?></code></div>
                                </div>
                                
                                <div class="row mb-3">
                                    <div class="col-6 text-start text-muted">Date:</div>
                                    <div class="col-6 text-end"><strong><?= date('F j, Y \a\t g:i A') ?></strong></div>
                                </div>
                                
                                <hr>
                                
                                <div class="row">
                                    <div class="col-6 text-start fs-5">Amount Paid:</div>
                                    <div class="col-6 text-end">
                                        <strong class="fs-4 text-success"><?= $currency_symbol ?><?= number_format($payment['amount'], 2) ?></strong>
                                    </div>
                                </div>
                            </div>
                        </div>
                        
                        <!-- What's Next -->
                        <div class="alert alert-info text-start">
                            <h6><i class="bi bi-info-circle me-2"></i>What's Next?</h6>
                            <ul class="mb-0">
                                <li>Your child's account is now <strong>active</strong></li>
                                <li>Subjects have been added to their profile</li>
                                <li>You'll receive an email confirmation shortly</li>
                                <li>You can view payment history in your dashboard</li>
                            </ul>
                        </div>
                        
                        <!-- Action Buttons -->
                        <div class="d-grid gap-2">
                            <a href="dashboard.php" class="btn btn-primary btn-lg">
                                <i class="bi bi-house me-2"></i>Go to Dashboard
                            </a>
                            <button onclick="window.print()" class="btn btn-outline-secondary">
                                <i class="bi bi-printer me-2"></i>Print Receipt
                            </button>
                        </div>
                    </div>
                </div>
                
                <div class="text-center mt-3">
                    <small class="text-muted">
                        <i class="bi bi-envelope me-1"></i>
                        A copy of this receipt has been sent to your email
                    </small>
                </div>
            </div>
        </div>
    </div>
    
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
    <script>
        // Auto-redirect to dashboard after 30 seconds
        setTimeout(function() {
            window.location.href = 'dashboard.php';
        }, 30000);
    </script>
</body>
</html>

