<?php
/**
 * Registration Complete
 * Shows success message with login credentials
 */

session_start();

if (!isset($_SESSION['registration_success'])) {
    header('Location: index.php');
    exit;
}

$credentials = $_SESSION['registration_success'];
unset($_SESSION['registration_success']); // Clear after showing once

?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Registration Complete!</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.0/font/bootstrap-icons.min.css" rel="stylesheet">
    <style>
        body {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            min-height: 100vh;
            display: flex;
            align-items: center;
            padding: 20px;
        }
        .card {
            border: none;
            border-radius: 1rem;
            box-shadow: 0 10px 40px rgba(0,0,0,0.2);
        }
        .credentials-box {
            background: linear-gradient(135deg, #f8f9fa 0%, #e9ecef 100%);
            border: 3px dashed #0d6efd;
            border-radius: 10px;
            padding: 30px;
        }
        .credential-item {
            background: white;
            padding: 15px;
            border-radius: 8px;
            margin-bottom: 15px;
            box-shadow: 0 2px 8px rgba(0,0,0,0.1);
        }
        @media print {
            body { background: white; }
            .no-print { display: none; }
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-lg-6">
                <div class="card">
                    <div class="card-body text-center py-5">
                        
                        <!-- Success Icon -->
                        <div class="mb-4">
                            <i class="bi bi-check-circle display-1 text-success"></i>
                        </div>
                        
                        <h1 class="text-success mb-2">Registration Complete!</h1>
                        <p class="lead mb-4">Your student account has been created successfully</p>
                        
                        <!-- Credentials Box -->
                        <div class="credentials-box text-start my-4">
                            <h4 class="text-center mb-4">
                                <i class="bi bi-key-fill me-2"></i>Your Login Credentials
                            </h4>
                            
                            <div class="credential-item">
                                <div class="d-flex justify-content-between align-items-center">
                                    <div>
                                        <small class="text-muted d-block">Username</small>
                                        <h3 class="mb-0 text-primary font-monospace">
                                            <?= htmlspecialchars($credentials['username']) ?>
                                        </h3>
                                    </div>
                                    <button class="btn btn-sm btn-outline-primary" 
                                            onclick="copyToClipboard('<?= htmlspecialchars($credentials['username']) ?>')">
                                        <i class="bi bi-clipboard"></i>
                                    </button>
                                </div>
                            </div>
                            
                            <div class="credential-item">
                                <div class="d-flex justify-content-between align-items-center">
                                    <div>
                                        <small class="text-muted d-block">Password</small>
                                        <h3 class="mb-0 text-primary font-monospace">
                                            <?= htmlspecialchars($credentials['password']) ?>
                                        </h3>
                                    </div>
                                    <button class="btn btn-sm btn-outline-primary" 
                                            onclick="copyToClipboard('<?= htmlspecialchars($credentials['password']) ?>')">
                                        <i class="bi bi-clipboard"></i>
                                    </button>
                                </div>
                            </div>
                            
                            <div class="alert alert-warning mt-3 mb-0">
                                <i class="bi bi-exclamation-triangle me-2"></i>
                                <strong>Important:</strong> Please save these credentials! 
                                They have also been sent to <strong><?= htmlspecialchars($credentials['email']) ?></strong>
                            </div>
                        </div>
                        
                        <!-- Next Steps -->
                        <div class="alert alert-info text-start">
                            <h6><i class="bi bi-list-check me-2"></i>Next Steps:</h6>
                            <ol class="mb-0">
                                <li class="mb-2">Save your username and password in a safe place</li>
                                <li class="mb-2">Check your email for a copy of these credentials</li>
                                <li class="mb-2">Login to access your student dashboard</li>
                                <li>Complete your profile and view your subjects</li>
                            </ol>
                        </div>
                        
                        <!-- Action Buttons -->
                        <div class="d-grid gap-2 mt-4 no-print">
                            <a href="admin/login.php" class="btn btn-primary btn-lg">
                                <i class="bi bi-box-arrow-in-right me-2"></i>
                                Login to Your Account Now
                            </a>
                            <button onclick="window.print()" class="btn btn-outline-secondary">
                                <i class="bi bi-printer me-2"></i>Print This Page
                            </button>
                        </div>
                        
                        <p class="text-muted mt-4 mb-0">
                            <small>
                                Need help? Contact your school administration or visit the 
                                <a href="help.php">help center</a>.
                            </small>
                        </p>
                        
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <script>
        function copyToClipboard(text) {
            navigator.clipboard.writeText(text).then(function() {
                // Show success feedback
                const btn = event.target.closest('button');
                const originalHTML = btn.innerHTML;
                btn.innerHTML = '<i class="bi bi-check"></i>';
                btn.classList.add('btn-success');
                btn.classList.remove('btn-outline-primary');
                
                setTimeout(() => {
                    btn.innerHTML = originalHTML;
                    btn.classList.remove('btn-success');
                    btn.classList.add('btn-outline-primary');
                }, 2000);
            });
        }
    </script>
</body>
</html>

