<?php
session_start();
require_once 'config.php';
require_once 'includes/functions.php';
require_once 'includes/sms_functions.php';
require_once 'includes/email_functions.php';
require_once 'includes/url_helper.php';

$method = $_GET['method'] ?? 'sms';
$phone = $_SESSION['verification_phone'] ?? '';
$email = $_SESSION['verification_email'] ?? '';
$student_name = $_SESSION['student_name'] ?? 'Student';
$school_name = $_SESSION['school_name'] ?? 'School';

// Generate new code/token
if ($method === 'sms' && !empty($phone)) {
    $verification_code = generateVerificationCode(6);
    
    try {
        $result = sendVerificationSMS($phone, $student_name, $verification_code, $school_name);
        
        if ($result['success']) {
            $_SESSION['success'] = 'Verification code resent to your phone!';
            $_SESSION['sms_sent_status'] = true;
        } else {
            $_SESSION['error'] = 'Failed to resend SMS: ' . ($result['error'] ?? 'Unknown error');
            $_SESSION['sms_sent_status'] = false;
        }
    } catch (Exception $e) {
        $_SESSION['error'] = 'Failed to resend SMS: ' . $e->getMessage();
        $_SESSION['sms_sent_status'] = false;
    }
    
} elseif ($method === 'email' && !empty($email)) {
    $verification_token = bin2hex(random_bytes(32));
    
    try {
        // Update token in database - use application_id from session if available
        $pdo = getDB();
        if (!empty($_SESSION['application_id'])) {
            $stmt = $pdo->prepare("
                UPDATE student_applications 
                SET email_verification_token = ? 
                WHERE id = ?
            ");
            $stmt->execute([$verification_token, $_SESSION['application_id']]);
        } else {
            // Fallback: find by email
            $stmt = $pdo->prepare("
                UPDATE student_applications 
                SET email_verification_token = ? 
                WHERE email = ? 
                AND application_status = 'submitted'
                ORDER BY submitted_at DESC 
                LIMIT 1
            ");
            $stmt->execute([$verification_token, $email]);
        }
        
        // Generate verification link (auto-detects localhost vs production)
        $verification_link = generateURL('verify_registration.php') . "?token=" . urlencode($verification_token);
        
        // Store verification link in session for fallback
        $_SESSION['verification_link'] = $verification_link;
        $_SESSION['verification_token'] = $verification_token;
        
        // Get school name for email
        $school_name = $_SESSION['school_name'] ?? 'Your School';
        
        // Create email content
        $email_subject = "Verify Your Registration - " . $school_name;
        $email_message = '
<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Email Verification</title>
</head>
<body style="margin:0;padding:0;font-family:Arial,sans-serif;background-color:#f4f4f4;">
    <table role="presentation" style="width:100%;border-collapse:collapse;background-color:#f4f4f4;padding:20px 0;">
        <tr>
            <td align="center">
                <table role="presentation" style="max-width:600px;width:100%;background-color:#ffffff;border-radius:8px;box-shadow:0 2px 8px rgba(0,0,0,0.1);">
                    <tr>
                        <td style="padding:40px 30px;text-align:center;background:linear-gradient(135deg, #667eea 0%, #764ba2 100%);border-radius:8px 8px 0 0;">
                            <h1 style="margin:0;color:#ffffff;font-size:28px;">Verify Your Registration</h1>
                        </td>
                    </tr>
                    <tr>
                        <td style="padding:40px 30px;">
                            <p style="font-size:16px;color:#333333;line-height:1.6;margin:0 0 20px;">Dear ' . htmlspecialchars($student_name) . ',</p>
                            <p style="font-size:16px;color:#333333;line-height:1.6;margin:0 0 30px;">Please verify your email address to proceed with your application.</p>
                            
                            <table role="presentation" style="width:100%;margin:30px 0;">
                                <tr>
                                    <td align="center">
                                        <a href="' . $verification_link . '" style="display:inline-block;background-color:#0d6efd;color:#ffffff;font-size:16px;font-weight:bold;text-decoration:none;padding:15px 40px;border-radius:5px;text-align:center;">Verify Email & Continue</a>
                                    </td>
                                </tr>
                            </table>
                            
                            <p style="font-size:14px;color:#666666;margin:20px 0;text-align:center;">Or copy this link: <br><span style="color:#0d6efd;word-break:break-all;">' . $verification_link . '</span></p>
                            
                            <p style="font-size:13px;color:#999999;margin:30px 0 0;text-align:center;">This link will expire in 48 hours.</p>
                        </td>
                    </tr>
                </table>
            </td>
        </tr>
    </table>
</body>
</html>';
        
        // Send email using sendEmail function (already required at top)
        $result = sendEmail($email, $student_name, $email_subject, $email_message);
        
        if ($result) {
            $_SESSION['success'] = 'Verification email resent!';
            $_SESSION['email_sent_status'] = true;
            $_SESSION['verification_method'] = 'email';
        } else {
            $_SESSION['error'] = 'Failed to resend email';
            $_SESSION['email_sent_status'] = false;
        }
    } catch (Exception $e) {
        $_SESSION['error'] = 'Failed to resend email: ' . $e->getMessage();
        $_SESSION['email_sent_status'] = false;
        error_log("Resend verification email error: " . $e->getMessage());
    }
} else {
    $_SESSION['error'] = 'Invalid verification method or missing information';
}

$_SESSION['show_verification_form'] = true;
// Build absolute URL for redirect (auto-detects localhost vs production)
header('Location: ' . generateURL('register_student.php'));
exit;

