<?php
require_once '../../includes/functions.php';
require_once '../../includes/school_context.php';

requireAdminLogin();

if (!isSuperAdmin()) {
    header('Location: ../dashboard.php');
    exit;
}

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    exit('Method Not Allowed');
}

$csrfToken = $_POST['csrf_token'] ?? '';
if (!validateCSRFToken($csrfToken)) {
    header('Location: list.php?status=invalid_csrf');
    exit;
}

$action = $_POST['action'] ?? '';
$schoolId = (int)($_POST['school_id'] ?? 0);
$redirectPreference = $_POST['redirect'] ?? 'view';

$school = getSchoolById($schoolId);
if (!$school) {
    header('Location: list.php?status=not_found');
    exit;
}

$status = 'error';

switch ($action) {
    case 'soft_delete':
        $status = softDeleteSchool($school) ? 'soft_deleted' : 'error';
        break;
    case 'restore':
        $status = restoreSchool($school) ? 'restored' : 'error';
        break;
    case 'permanent_delete':
        $status = permanentlyDeleteSchool($school) ? 'deleted' : 'error';
        break;
    default:
        $status = 'invalid_action';
        break;
}

if ($action === 'permanent_delete' && $status === 'deleted') {
    header('Location: list.php?status=deleted');
    exit;
}

if ($redirectPreference === 'list') {
    header("Location: list.php?status={$status}");
} else {
    header("Location: view.php?id={$schoolId}&status={$status}");
}
exit;


