<?php
require_once __DIR__ . '/../includes/school_registration_helper.php';

$code = 'AUTO' . strtoupper(bin2hex(random_bytes(2)));
$email = 'auto+' . strtolower($code) . '@example.com';

try {
    $result = createSchoolAccount(
        [
            'school_name'    => 'Automation Test ' . $code,
            'reference_code' => $code,
            'admin_email'    => $email,
            'admin_password' => 'TempPass123!',
            'description'    => 'Automated CLI test run at ' . date('Y-m-d H:i:s'),
        ],
        [
            'created_by'         => null,
            'send_welcome_email' => false,
        ]
    );

    echo "✅ School registration succeeded.\n";
    echo "Reference Code: {$result['reference_code']}\n";
    echo "Admin Username: {$result['admin_username']}\n";
    echo "Admin Email: {$result['admin_email']}\n";
    echo "Admin Login URL: {$result['admin_login_url']}\n";
} catch (Throwable $e) {
    echo "❌ Registration failed: " . $e->getMessage() . "\n";
    exit(1);
}

