<?php
require_once 'config.php';

$pdo = getDB();
$tables = ['admin_wallet', 'wallet_transactions', 'withdrawal_requests', 'platform_fees', 'academy_references'];

echo "Checking wallet system tables...\n\n";
$missing = [];

foreach ($tables as $table) {
    try {
        $stmt = $pdo->query("SELECT COUNT(*) FROM $table");
        $count = $stmt->fetchColumn();
        echo "✓ $table exists (rows: $count)\n";
    } catch (PDOException $e) {
        echo "✗ Missing: $table\n";
        $missing[] = $table;
    }
}

echo "\n";
if (empty($missing)) {
    echo "✅ All wallet system tables exist!\n";
} else {
    echo "⚠ Missing tables: " . implode(', ', $missing) . "\n";
    echo "   Run the complete database schema to create them.\n";
}

